package com.wecloud.im.biz.action;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

import com.alibaba.fastjson.JSON;
import com.wecloud.im.biz.module.message.controller.param.AgreeToMultiMeetParam;
import com.wecloud.im.biz.module.message.controller.param.HeartbeatMultiMeetParam;
import com.wecloud.im.biz.module.message.controller.param.InviteToMultiMeetParam;
import com.wecloud.im.biz.module.message.controller.param.LeaveFromMultiMeetParam;
import com.wecloud.im.biz.module.message.controller.param.NotAnsweredMultiMeetParam;
import com.wecloud.im.biz.module.message.controller.param.RejectToMultiMeetParam;
import com.wecloud.im.biz.module.multimeet.service.MultiMeetService;
import com.wecloud.im.core.common.api.ApiCode;
import com.wecloud.im.server.model.WsResponse;
import com.wecloud.netty.dispatch.annotation.ActionMapping;

@Slf4j
@Component
@ActionMapping(value = "/im/multiMeet")
@Api(value = "ws-多人音视频通话", tags = {"ws-多人音视频通话"})
public class MultiMeetAction {

    @Autowired
    private MultiMeetService multiMeetService;

    /**
     * 邀请客户端加入
     * @return
     */
    @ActionMapping("/invite")
    @ApiOperation(value = "邀请加入多人音视频会议", notes = "邀请加入多人音视频会议")
    public WsResponse<Map<String, Boolean>> invite(@Validated InviteToMultiMeetParam data) {
        log.info("邀请加入多人音视频会议入参 {}", JSON.toJSONString(data));
        if (CollectionUtils.isEmpty(data.getToClients())) {
            return WsResponse.fail(ApiCode.PARAMETER_EXCEPTION);
        }
        multiMeetService.invite(data);
        return WsResponse.ok();
    }

    @ActionMapping("/reject")
    @ApiOperation(value = "拒接进入会议", notes = "拒接进入会议")
    public WsResponse<Map<String, Boolean>> reject(RejectToMultiMeetParam data) {
        log.info("拒绝加入多人音视频会议入参 {}", JSON.toJSONString(data));
        multiMeetService.reject(data);
        return WsResponse.ok();
    }

    @ActionMapping("/agree")
    @ApiOperation(value = "同意进入会议", notes = "同意进入会议")
    public WsResponse<Map<String, Boolean>> agree(AgreeToMultiMeetParam data) {
        log.info("同意进入多人音视频会议入参 {}", JSON.toJSONString(data));
        multiMeetService.agree(data);
        return WsResponse.ok();
    }

    @ActionMapping("/leave")
    @ApiOperation(value = "主动挂断(离开会议)", notes = "主动挂断(离开会议)")
    public WsResponse<Map<String, Boolean>> leave(LeaveFromMultiMeetParam data) {
        log.info("主动挂断多人音视频会议入参 {}", JSON.toJSONString(data));
        multiMeetService.leave(data);
        return WsResponse.ok();
    }

    @ActionMapping("/notAnswered")
    @ApiOperation(value = "未接听", notes = "未接听")
    public WsResponse<Map<String, Boolean>> notAnswered(NotAnsweredMultiMeetParam data) {
        log.info("多人音视频会议未接听入参 {}", JSON.toJSONString(data));
        multiMeetService.notAnswered(data);
        return WsResponse.ok();
    }

    @ActionMapping("/heartbeat")
    @ApiOperation(value = "发送心跳", notes = "发送心跳")
    public WsResponse<Map<String, Boolean>> heartbeat(HeartbeatMultiMeetParam data) {
        multiMeetService.heartbeat(data);
        return WsResponse.ok();
    }

    @ActionMapping("/isBeCalling")
    @ApiOperation(value = "是否正在被呼叫", notes = "是否正在被呼叫")
    public WsResponse<Map<String, Boolean>> isBeCalling() {
        multiMeetService.isBeCalling();
        return WsResponse.ok();
    }
}
