package com.wecloud.im.service.impl;

import com.wecloud.im.entity.ImMessage;
import com.wecloud.im.mapper.ImMessageMapper;
import com.wecloud.im.service.ImMessageService;
    import com.wecloud.im.param.ImMessagePageParam;
    import com.wecloud.im.param.ImMessageQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
    import io.geekidea.springbootplus.framework.core.pagination.Paging;
    import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
    import com.baomidou.mybatisplus.core.metadata.IPage;
    import com.baomidou.mybatisplus.core.metadata.OrderItem;
    import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
    import org.springframework.transaction.annotation.Transactional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 消息存储表 服务实现类
 *
 * @author wei
 * @since 2021-04-29
 */
@Slf4j
@Service
public class ImMessageServiceImpl extends BaseServiceImpl<ImMessageMapper, ImMessage> implements ImMessageService {

@Autowired
private ImMessageMapper imMessageMapper;

@Transactional(rollbackFor = Exception.class)
@Override
public boolean saveImMessage(ImMessage imMessage)throws Exception{
        return super.save(imMessage);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean updateImMessage(ImMessage imMessage)throws Exception{
        return super.updateById(imMessage);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean deleteImMessage(Long id)throws Exception{
        return super.removeById(id);
        }

    @Override
    public ImMessageQueryVo getImMessageById(Long id)throws Exception{
            return imMessageMapper.getImMessageById(id);
            }

@Override
public Paging<ImMessageQueryVo> getImMessagePageList(ImMessagePageParam imMessagePageParam)throws Exception{
        Page<ImMessageQueryVo> page=new PageInfo<>(imMessagePageParam,OrderItem.desc(getLambdaColumn(ImMessage::getCreateTime)));
            IPage<ImMessageQueryVo> iPage= imMessageMapper.getImMessagePageList(page, imMessagePageParam);
        return new Paging<ImMessageQueryVo>(iPage);
        }

        }
