# wecloud-RTC音视频客户端信令对接文档

## 文档描述

此文档为单人RTC音视频通讯技术对接文档

由于RTC基于wecloud-im即时通讯服务,**对接RTC前,需要先对接wecloud-im服务**

## 核心概念说明

### 频道与会话

频道与会话的概念不一样

```
1. 引入"频道RtcChannel"概念, 可以不基于会话发起音视频通话
2. 目前频道只支持两个client,进行通话的两端必须先加入到同一个"频道",所有的指令都在频道内进行转发
3. 允许不在同个会话中的两个client加入到同个频道进行通话 (可配置是否两个client必须在同一个会话才能发起音视频通话)
4. 一个频道可以由通话发起者绑定到会话ID,"挂断","未接听"等状态会同步到会话, 未绑定将不同步到会话(可选)
5. 连接websocket时带上client类型, 如web,安卓,ios
client需要监听频道内 状态更新(房间断开,挂断)、用户状态更新(用户加入, 用户退出)、流状态更新(切换音频 切换视频)
```

## 流程图

![单人WebRTC发起流程图](https://tva1.sinaimg.cn/large/008i3skNgy1guxhnn6x64j60jr0xgmz302.jpg)

## 指令说明

#### **subCmd**子类型 

##### 客户端**请求**指令列表:

**create**:创建频道
**join**: 加入频道

##### 服务端**响应**指令列表:

**rtcCall**:接收到RTC邀请
**clientEvent** : 用户状态更新事件(用户加入,用户退出,用户拒接邀请)
**typeEvent**:流状态更新(切换音频 切换视频)
**statusEvent**:状态更新(网络断开,挂断)
**SDP**:SDP数据转发
**busy**:忙线

## 创建频道 发起RTC音视频通话

### 1.client发起方 发起请求:

**示例一: 必传参数:**

```json
{
"reqId":"555111-ad-afd12",
"cmd":3,
"data":{
  "toClient":["client_3030"],
  "subCmd":"create",
  "type":"video"
	}
}

```

**示例二: 全部可选参数:**

```json
{
"reqId":"555111-ad-afd12",
"cmd":3,
"data":{
  "diyParam自定义字段":"aaaa自已定义字段的值",
  "toConversation":null,
  "toClient":["client_3030"],
  "subCmd":"create",
  "type":"video",
  "push":{
    "title":"xxx正在邀请你视频通话",
    "subTitle":"点击接听"
  },
  "attrs":{
    "a":"示例: 用户自定义的一些键值对A",
    "b":"示例: 存储用户自定义的一些键值对B"
   }
	}
}
```

**说明:** toConversation会话ID可以为空, 为空时通话记录将不会记录到会话当中, 如"未接听", "已拒绝"等事件通知不会写入到会话的聊天记录中.

**请求参数描述**

| 字段名  | 字段类型 | 是否可空 | 说明 |
| ---- | -------- | -- | ------ |
| cmd            | String   | 否       | 指令码                 |
| attrs          | Object   | 是       | 自定义拓展字段		 |
| toConversation | Long     | 是      | 会话id,可为空             |
| diyParam自定义字段 | Object     | 是       | 自定义拓展字段        |
| push | String     | 是       | 接收方展示的系统推送内容             |
| subCmd | String     | 否       | 子类型指令           |
| toClient | Array[String] | 否       | 被邀请的客户端ID              |
| type | String | 否       | 类型: "video" 或 "voice" |



### 2.服务端向client发起方响应数据:

```json
{
"reqId":"555111-ad-afd12",
"cmd":5,
"data":{
  "channelId":1234263457652
	}
}
```

**参数描述**

| 字段名  | 字段类型 | 是否可空 | 说明 |
| ---- | -------- | -- | ------ |
| cmd            | String   | 否       | 指令码                 |
| channelId | Long     | 否       | 由服务端创建的频道id   |



## 接收方收到RTC音视频通话邀请

服务端向client接收方下发数据:

```json
{
"cmd":4,
"data":{
  "subCmd":"rtcCall",
  "subData":{
    "type":"video",
    "toConversation":null,
    "channelId":1234263457652,
    "sender":"client_1010"
  },
  "diyParam自定义字段":"aaaa自已定义字段的值",
  "attrs":{
    "a":"示例: 用户自定义的一些键值对",
    "b":"存储用户自定义的一些键值对"
  }
	}
}
```

**参数描述**

| 字段名  | 字段类型 | 是否可空 | 说明 |
| ---- | -------- | -- | ------ |
| cmd            | String   | 否       | 指令码                 |
| attrs          | Object   | 是       | 自定义拓展字段		 |
| toConversation | Long     | 否       | 绑定的会话id              |
| diyParam自定义字段 | Object     | 是       | 自定义拓展字段        |
| subCmd | String     | 否       | 子类型指令            |
| sender | String     | 否       | 发起通话的客户端ID              |
| channelId | Long     | 否       | 由服务端创建的频道id   |
| type | String | 否       | 类型: "video" 或 "voice" |

## 同意加入频道

client接收方向服务端请求数据:

```json
{
"reqId":"123",
"cmd":3,
"data":{
  "channelId":1234263457652,
  "subCmd":"join"
	}
}
```

**参数描述**

| 字段名  | 字段类型 | 是否可空 | 说明 |
| ---- | -------- | -- | ------ |
| cmd            | String   | 否       | 指令码                 |
| attrs          | Object   | 是       | 自定义拓展字段		 |
| diyParam自定义字段 | Object     | 是       | 自定义拓展字段        |
| subCmd | String     | 否       | 子类型指令            |

## 通知:有client加入频道

服务端向频道内其他client响应数据:
```json
{
"cmd":4,
"data":{
  "subCmd":"clientEvent",
  "subData":{
    "channelId":1234263457652,
    "type":"join",
    "clientId":7657567,
  }
	}
}
```

## 拒绝加入频道

client接收方向服务端请求数据:

```json
{
"reqId":"123",
"cmd":3,
"data":{
  "subCmd":"reject",
  "diyParam自定义字段":"aaaa自已定义字段的值",
  "channelId":1234263457652,
  "attrs":{}
	}
}
```

**说明:** 

**参数描述**

| 字段名  | 字段类型 | 是否可空 | 说明 |
| ---- | -------- | -- | ------ |
| cmd            | String   | 否       | 指令码                 |
| attrs          | Object   | 是       | 自定义拓展字段		 |
| toConversation | Long     | 否       | 会话id                 |
| diyParam自定义字段 | Object     | 是       | 自定义拓展字段        |
| subCmd | String     | 否       | 子类型              |

## 通知:有Client拒绝加入频道

服务端向频道内其他client响应数据:

```json
{
"cmd":4,
"data":{
  "subCmd":"clientEvent",
  "subData":{
    "channelId":1234263457652,
    "type":"reject",
    "clientId":7657567,
  }
	}
}
```

## 流媒体描述信息SDP转发

（服务端仅负责转发）（ice_candidate,anser,offer）

### client发送SDP

```json
{
"reqId":"123",
"cmd":3,
"data":{
  "subCmd":"sdp",
  "channelId":1234263457652,
  "sdpData":"xxxxxxxxxxxxxxxx",
  "diyParam自定义字段":"aaaa自已定义字段的值",
  "attrs":{}
	}
}
```


### client接收SDP

```json
{
"cmd":4,
"data":{
  "subCmd":"sdp",
  "subData":{
    "channelId":1234263457652,
    "clientId":7657567,
    "sdpData":"xxxxxxxxxxxxxxxx",
    "diyParam自定义字段":"aaaa自已定义字段的值",
    "attrs":{}
  }
	}
}
```

## 主动挂断(离开频道)

client主动离开频道

向服务端请求:

```json
{
"reqId":"123",
"cmd":3,
"data":{
  "subCmd":"leave",
  "channelId":1234263457652
	}
}
```

## 通知:有client离开频道

服务端向频道内其他client响应数据:

```json
{
"cmd":4,
"data":{
  "subCmd":"clientEvent",
  "subData":{
    "channelId":1234263457652,
    "type":"leave",
    "clientId":7657567,
  }
	}
}
```

## 对方忙线(对方正在通话中)

服务端响应给发起方

```json
{
"reqId":"555111-ad-afd12",
"cmd":5,
"data":{
  "subCmd":"busy",
  "subData":{
    "channelId":1234263457652,
    "clientId":7657567
  }
	}
}
```

## 断线重连

重新join进频道即可重连

## 对方是否还挂起

## 视频/音频切换

## 查询对方是否离开



