package com.wecloud.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.wecloud.im.entity.ImMultiRtcRoom;
import com.wecloud.im.enums.MultiRtcRoomStateEnum;
import com.wecloud.im.mapper.ImMultiRtcRoomMapper;
import com.wecloud.im.service.ImMultiRtcRoomService;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

/**
 * @Author wenzhida
 * @Date 2022/3/16 9:27
 * @Description 多人音视频房间服务接口实现
 */
@Slf4j
@Service
@CacheConfig(cacheNames = "multiRtc")
public class ImMultiRtcRoomServiceImpl extends BaseServiceImpl<ImMultiRtcRoomMapper, ImMultiRtcRoom> implements ImMultiRtcRoomService {

    @Autowired
    private ImMultiRtcRoomService imMultiRtcRoomService;

    @Override
    @Cacheable(key = "'rtcRoomKey_' + #p0+#p1")
    public ImMultiRtcRoom getCachedMultiRtcRoom(Long fkAppid, String roomId) {
        ImMultiRtcRoom rtcRoom = imMultiRtcRoomService.getOne(new QueryWrapper<ImMultiRtcRoom>().lambda()
                .eq(ImMultiRtcRoom::getFkAppid, fkAppid)
                .eq(ImMultiRtcRoom::getRoomId, roomId));
        return rtcRoom;
    }

    @Override
    @CacheEvict(key = "'rtcRoomKey_' + #p0+#p1")
    public void deleteMultiRtcRoomCache(Long fkAppid, String roomId) {
    }

    @Override
    public void updateMultiRtcRoomState(String roomId, Integer state) {
        imMultiRtcRoomService.update(new UpdateWrapper<ImMultiRtcRoom>().lambda()
                .eq(ImMultiRtcRoom::getRoomId, roomId)
                .set(ImMultiRtcRoom::getState, state));
    }
}
