package com.jumeirah.common.enums;

/**
 * 状态，0-审核中，1-进行中，2-已完成，99-取消
 */
public enum StrokeStatusEnum {

    UNDER_REVIEW(0, "审核中"),
    PROCESSING(1, "进行中"),
    COMPLETED(2, "已完成"),
    CANCEL(99, "取消");

    /**
     * 编号
     */
    private final Integer id;
    /**
     * 名称
     */
    private final String name;

    StrokeStatusEnum(Integer id, String name) {

        this.id = id;
        this.name = name;

    }
}
