package com.wecloud.im.sdk.model;

import lombok.Builder;
import lombok.Data;

import java.util.Map;

/**
 * 创建会话
 * @Author luozh
 * @Date 2022年05月31日 16:09
 * @Version 1.0
 */
@Data
@Builder
public class CreateConversationRequest extends WebServiceRequest {

    /**
     * 会话名称
     */
    private String name;

    /**
     * 创建人用户id
     */
    private String creatorUserId;

    /**
     * 成员用户id
     */
    private String memberUserIds;

    /**
     * 会话属性，1:单聊 5:临时会话 6:系统会话
     */
    private String chatType;

    /**
     * Map格式,可选	自定义属性，供开发者扩展使用。")
     */
    private Map<String, Object> attributes;

}
