package com.wecloud.im.config;

import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.springframework.context.annotation.Bean;

/**
 * @Author wenzhida
 * @Date 2022/1/25 15:32
 * @Description 创建生产者的工厂bean
 */
public class RocketMqFactoryBeanConfig {

    @Bean
    public DefaultMQProducer defaultProducer(RocketMqProperties configuration) throws Exception {
        if (configuration.getNamesrvAddr() == null) {
            throw new IllegalArgumentException("rocketmq.nameSrvAddress 是必须的参数");
        }
        DefaultMQProducer producer = new DefaultMQProducer(configuration.getProducerId());
        producer.setNamesrvAddr(configuration.getNamesrvAddr());
        producer.setInstanceName(System.currentTimeMillis() + "");
        producer.start();
        producer.setVipChannelEnabled(false);
        return producer;
    }


}
