package com.ym.im.entity;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 行程表
 *
 * @author wei
 * @since 2020-09-29
 */
@Data
@Accessors(chain = true)
public class Stroke implements Serializable {
    private Long id;
    private String cityOutsetName;//起飞城市
    private String cityArriveName;//到达城市
    private Long outsetTime;//起飞时间
    private Long returnTime;//返程时间
    private int type;//行程类型 0-单程，1-往返行程，2-货运，3-医疗
    private Long userId;
    private Long mcId;
    private String outsetAirportName;//出发机场名称
    private String arriveAirportName;//到达机场名称
    private String backOutsetAirportName;//返程出发机场名称
    private String backArriveAirportName;//返程到达机场名称
    private boolean isDiscount;//是否是优惠调机

}
