package com.wecloud.im.router;

import com.alibaba.fastjson.JSON;
import com.wecloud.im.entity.ImIosApns;
import com.wecloud.im.service.ImIosApnsService;
import com.wecloud.imserver.client.api.ImIosApnsFacade;
import com.wecloud.imserver.client.model.ao.IosApnsQueryAO;
import com.wecloud.imserver.client.model.dto.ImIosApnsDTO;
import com.wecloud.imserver.client.model.dto.Result;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Author wenzhida
 * @Date 2022/1/27 17:01
 * @Description ios apns信息rpc获取
 */
@Slf4j
@Service
@DubboService
public class ImIosApnsFacadeImpl implements ImIosApnsFacade {

    @Autowired
    private ImIosApnsService imIosApnsService;

    /**
     * 获取ios apns
     * @param queryAO 入参ao
     * @return 出参
     */
    @Override
    public Result<ImIosApnsDTO> getImIosApns(IosApnsQueryAO queryAO) {
        log.info("获取ios apns入参信息: {}", JSON.toJSONString(queryAO));
        ImIosApns apns = imIosApnsService.getImIosApnsByAppId(queryAO.getAppId());
        if (apns == null) {
            return Result.getBusinessException("查无apns证件信息", null);
        }
        ImIosApnsDTO iosApnsDTO = new ImIosApnsDTO();
        BeanUtils.copyProperties(apns, iosApnsDTO);
        return Result.getSuccessResult(iosApnsDTO);
    }
}
