package com.wecloud.im.action;

import com.alibaba.fastjson.JSON;
import com.wecloud.dispatch.annotation.ActionMapping;
import com.wecloud.im.param.*;
import com.wecloud.im.ws.model.WsResponse;
import com.wecloud.multimeet.service.MultiMeetService;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Slf4j
@Component
@ActionMapping(value = "/im/multiMeet")
@Api(value = "ws-多人音视频通话", tags = {"多人音视频通话"})
public class MultiMeetAction {

    @Autowired
    private MultiMeetService multiMeetService;

    /**
     * 邀请客户端加入
     */
    @ActionMapping("/invite")
    @ApiOperation(value = "邀请加入多人音视频会议", notes = "邀请加入多人音视频会议")
    public WsResponse<Boolean> invite(@Validated InviteToMultiMeetParam param) {
        log.info("邀请加入多人音视频会议入参 {}", JSON.toJSONString(param));
        if (CollectionUtils.isEmpty(param.getToClients())) {
            return WsResponse.fail(ApiCode.PARAMETER_EXCEPTION);
        }
        multiMeetService.invite(param);
        return WsResponse.ok();
    }

    @ActionMapping("/reject")
    @ApiOperation(value = "拒接进入会议", notes = "拒接进入会议")
    public WsResponse<Boolean> reject(RejectToMultiMeetParam param) {
        log.info("拒绝加入多人音视频会议入参 {}", JSON.toJSONString(param));
        multiMeetService.reject(param);
        return WsResponse.ok();
    }

    @ActionMapping("/agree")
    @ApiOperation(value = "同意进入会议", notes = "同意进入会议")
    public WsResponse<Boolean> agree(AgreeToMultiMeetParam param) {
        log.info("同意进入多人音视频会议入参 {}", JSON.toJSONString(param));
        multiMeetService.agree(param);
        return WsResponse.ok();
    }

    @ActionMapping("/leave")
    @ApiOperation(value = "主动挂断(离开会议)", notes = "主动挂断(离开会议)")
    public WsResponse<Boolean> leave(LeaveFromMultiMeetParam param) {
        log.info("主动挂断多人音视频会议入参 {}", JSON.toJSONString(param));
        multiMeetService.leave(param);
        return WsResponse.ok();
    }

    @ActionMapping("/notAnswered")
    @ApiOperation(value = "未接听", notes = "未接听")
    public WsResponse<Boolean> notAnswered(NotAnsweredMultiMeetParam param) {
        log.info("多人音视频会议未接听入参 {}", JSON.toJSONString(param));
        multiMeetService.notAnswered(param);
        return WsResponse.ok();
    }

    @ActionMapping("/heartbeat")
    @ApiOperation(value = "发送心跳", notes = "发送心跳")
    public WsResponse<Boolean> heartbeat(HeartbeatMultiMeetParam param) {
        multiMeetService.heartbeat(param);
        return WsResponse.ok();
    }
}
