package com.wecloud.im.action;

import com.wecloud.dispatch.annotation.ActionMapping;
import com.wecloud.im.param.ImConvMemeClientRemarkNameParam;
import com.wecloud.im.param.ListConversationMembersParam;
import com.wecloud.im.param.add.ImConversationMemAttrUpdate;
import com.wecloud.im.service.ImConversationMembersService;
import com.wecloud.im.vo.ConversationMemberVo;
import com.wecloud.im.ws.model.WsResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

import java.util.List;

/**
 * @Author luozh
 * @Date 2022年04月02日 16:41
 * @Version 1.0
 */
@Slf4j
@Component
@ActionMapping(value = "/im/conversationMembers")
@Api(value = "ws-会话成员API", tags = {"会话成员"})
public class ConversationMembersAction {
    @Autowired
    private ImConversationMembersService imConversationMembersService;

    /**
     * 添加或修改会话成员备注
     */
    @ActionMapping("/updateClientRemarkName")
    @ApiOperation(value = "添加或修改会话成员备注", notes = "权限:目前只有client成员自己有权限操作")
    public WsResponse<Boolean> saveOrUpdateClientRemarkName(ImConvMemeClientRemarkNameParam imConvMemeClientRemarkNameParam) throws Exception {
        imConversationMembersService.saveOrUpdateClientRemarkName(imConvMemeClientRemarkNameParam);
        return WsResponse.ok();
    }


    /**
     * 添加或修改会话成员拓展字段
     */
    @ActionMapping("/updateAttr")
    @ApiOperation(value = "添加或修改会话成员拓展字段", notes = "权限:目前只有client成员自己有权限操作")
    public WsResponse<Boolean> saveOrUpdateAttr(ImConversationMemAttrUpdate imConversationMemAttrUpdate) throws Exception {
        boolean r = imConversationMembersService.saveOrUpdateAttr(imConversationMemAttrUpdate);
        if (r) {
            return WsResponse.ok();
        } else {
            return WsResponse.fail();
        }
    }


    /**
     * 会话中成员表列表
     */
    @ActionMapping("/getList")
    @ApiOperation(value = "获取会话中成员表列表")
    public WsResponse<List<ConversationMemberVo>> getImConversationMembersList(@Validated ListConversationMembersParam listConversationMembersParam) throws Exception {
        return WsResponse.ok(imConversationMembersService.getImConversationMembersList(listConversationMembersParam));
    }
}
