package com.wecloud.im.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 黑名单
 *
 * @author wei
 * @since 2021-06-17
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImClientBlacklist对象")
public class ImClientBlacklist extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "客户端id不能为空")
    @ApiModelProperty("客户端id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @ApiModelProperty("拉黑者")
    private Long fkClientIdPrevent;

    @ApiModelProperty("被拉黑")
    private Long fkClientIdBePrevent;

}
