package com.wecloud.im.controller;

import com.alibaba.fastjson.JSON;
import com.wecloud.im.param.ImMsgReceivedStatusUpdate;
import com.wecloud.im.param.MsgReadStatusUpdateParam;
import com.wecloud.im.param.UpdateMsgReadStatusByConversationParam;
import com.wecloud.im.service.ImInboxService;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 消息收件箱表 控制器
 *
 * @author wei
 * @since 2021-05-06
 */
@Slf4j
@RestController
@RequestMapping("/imInbox")
@Api(value = "消息收件箱表API", tags = {"消息收件箱表"})
public class ImInboxController extends BaseController {

    @Autowired
    private ImInboxService imInboxService;

    /**
     * 消息修改为已接收状态
     */
    @PostMapping("/msgReceivedUpdate")
    @ApiOperation(value = "消息修改为已接收状态")
    public ApiResult<Boolean> updateImMsgReceived(@RequestBody @Validated ImMsgReceivedStatusUpdate imMsgReceivedUpdate) throws Exception {
        log.info("消息修改为已接收状态入参 {}", JSON.toJSONString(imMsgReceivedUpdate));
        imInboxService.updateImMsgReceived(imMsgReceivedUpdate);
        return ApiResult.ok();
    }

    /**
     * 消息修改为已读状态
     */
    @PostMapping("/msgReadUpdate")
    @ApiOperation(value = "消息修改为已读状态")
    public ApiResult<Boolean> updateInMsgReadUpdate(@RequestBody MsgReadStatusUpdateParam msgReadStatusUpdateParam) throws Exception {
        log.info("消息修改为已读状态 {}", JSON.toJSONString(msgReadStatusUpdateParam));
        if (CollectionUtils.isEmpty(msgReadStatusUpdateParam.getMsgIds())) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION);
        }
        imInboxService.updateImMsgRead(msgReadStatusUpdateParam);
        return ApiResult.ok();
    }

    /**
     * 会话消息修改为已读状态
     */
    @PostMapping("/updateMsgReadStatusByConversation")
    @ApiOperation(value = "会话消息修改为已读状态")
    public ApiResult<Boolean> updateMsgReadStatusByConversation(@RequestBody UpdateMsgReadStatusByConversationParam param) throws Exception {
        log.info("会话消息修改为已读状态入参 {}", JSON.toJSONString(param));
        if (param.getConversationId() == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION);
        }
        return ApiResult.ok(imInboxService.updateMsgReadStatusByConversation(param));
    }

}

