package com.jumeirah.api.app.service;

import com.jumeirah.common.entity.AppUser;
import com.jumeirah.common.param.app.AppSmsRegisterParam;
import com.jumeirah.common.param.app.AppUserInfoParam;
import com.jumeirah.common.vo.app.LoginAppUserTokenVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;

import java.util.List;
import java.util.Set;

public interface AppUserApiService {

    /**
     * 注册
     *
     * @param loginParam
     * @param language
     * @return
     * @throws Exception
     */
    ApiResult<LoginAppUserTokenVo> register(AppSmsRegisterParam loginParam, String language) throws Exception;
//    ApiResult<LoginAppUserTokenVo> login(AppSmsRegisterParam loginParam, String language) throws Exception;

    /**
     * 修改或补充用户信息
     *
     * @param appUserInfoParam
     * @return
     * @throws Exception
     */
    boolean updateAppUser(AppUserInfoParam appUserInfoParam) throws Exception;

    ApiResult<Boolean> updatePhone(String phoneArea, String phone, String code) throws Exception;


    /**
     * 获取用户信息
     *
     * @param userId
     * @return
     */
    AppUser getUserInfo(Long userId);

    /**
     * 批量获取用户信息
     *
     * @param uids
     * @return
     */
    ApiResult<List<AppUser>> getAppUserList(Set<Long> uids);


}
