package com.wecloud.im.param.add;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.HashMap;

/**
 * 自定义透传内容
 *
 * @author wei
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImMsgSendToOnlineClient")
public class ImMsgSendRestApi extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "发送者id", required = true)
    private String senderClient;

    @ApiModelProperty(value = "自定义内容 ,为任意参数名称和类型的对象，供开发者扩展使用。", required = true)
    private HashMap content;

//    @ApiModelProperty(value = "会话id", required = true)
//    private Long conversationId;

}
