package com.ym.im.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * APP用户
 *
 * @author wei
 * @since 2020-09-23
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "AppUser对象")
@AllArgsConstructor
@NoArgsConstructor
public class AppUser implements Serializable {

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("用户名")
    private String username;

    @ApiModelProperty("姓")
    private String surname;

    @ApiModelProperty("名")
    private String name;

    @ApiModelProperty("公司名")
    private String companyName;

    @ApiModelProperty("微信号")
    private String wechat;

    @ApiModelProperty("出生日期")
    private String dateOfBirth;

    @ApiModelProperty("昵称")
    private String nickname;

    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("盐值")
    private String salt;

    @ApiModelProperty("手机号码")
    private String phone;

    @ApiModelProperty("手机区号")
    private String phoneArea;

    @ApiModelProperty("性别，0：女，1：男，默认1")
    private Integer gender;

    @ApiModelProperty("设备类型,1:安卓,2:ios")
    private Integer deviceType;

    @ApiModelProperty("头像")
    private String head;

    @ApiModelProperty("推送token")
    private String deviceToken;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("状态，0：禁用，1：启用，2：锁定")
    private Integer state;

    @ApiModelProperty("部门id")
    private Long departmentId;

    @ApiModelProperty("角色id")
    private Long roleId;

    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleted;

    @ApiModelProperty("版本")
    private Integer version;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

}
