package com.wecloud.rtc.service;

import com.fasterxml.jackson.core.JsonProcessingException;

import java.util.List;

/**
 * 管理rtc频道
 */
public interface MangerRtcCacheService {

    boolean isEmpty(String appKey, String clientId, Long rtcChannelId);

    /**
     * 创建一个频道
     *
     * @param appKey
     * @param clientId
     * @param rtcChannelId 雪花算法生成频道id
     */
    void create(String appKey, String clientId, Long rtcChannelId) throws JsonProcessingException;

    /**
     * 加入频道
     */
    void join(String appKey, String clientId, Long rtcChannelId);

    /**
     * 退出频道
     */
    void leave(String appKey, String clientId, Long rtcChannelId);

    /**
     * 根据频道ID获取频道内所有client
     */
    List<String> getClientListByRtcChannelId(Long rtcChannelId);

    /**
     * 根据客户端ID获取该客户端加入的频道ID
     */
    Long getRtcChannelIdListByClientId(String appKey, String clientId);

    /**
     * 获取客户端忙线/空闲状态
     *
     * @param appKey
     * @param clientId
     * @return true:忙线,false空闲
     */
    boolean getBusyStatus(String appKey, String clientId);

}
