package com.wecloud.netty.dispatch.common;

import lombok.NoArgsConstructor;

import java.util.HashMap;

/**
 * @author lixiaozhong
 */
@NoArgsConstructor
public class BaseRequest extends HashMap<String, Object> implements Request{

    public static final String ACTION = "action";
    public static final String REQ_ID = "reqId";

    /**
     * 请求的参数 action，用来寻找action类的path
     */
    private String action;

    /**
     * 请求id, 以判空是否请求成功, 服务端处理完成后 返回此id
     * 由前端生成，可以用uuid，也可以用时间戳
     */
    private String reqId;

    @Override
    public String getAction() {
        return (String)this.get(ACTION);
    }

    public void setAction(String action) {
        this.put(ACTION, action);
    }

    @Override
    public String getReqId() {
        return (String)this.get(REQ_ID);
    }

    public void setReqId(String reqId) {
        this.put(REQ_ID, reqId);
    }
}
