package com.wecloud.im.server.model.request;

import com.wecloud.im.server.enums.WsRequestCmdEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.HashMap;

/**
 * @Description null
 * @Author hewei hwei1233@163.com
 * @Date 2019-12-05
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ReceiveVO implements Serializable {

    /**
     * 枚举类 {@link WsRequestCmdEnum } 请求uri的编码
     * 由于websocket使用同一个通道发送数据，需要区分不同类型请求
     */
    private Integer cmd;

    /**
     * 转换保存json数据
     * 因集成版无法预先知道第三方应用所拓展的数据格式,所以用Object(hashmap)来保存应用上行参数,不能使用固定的成员变量或实体来接收
     */
    private HashMap data;

    /**
     * 请求id, 以判空是否请求成功, 服务端处理完成后 返回此id
     * 由前端生成，可以用uuid，也可以用时间戳
     */
    private String reqId;

}
