package com.wecloud.im.server.enums;

/**
 * @Description webrtc响应类型
 * @Author hewei hwei1233@163.com
 * @Date 2019-12-05
 */
public enum WsRtcResponseSubCmdEnum {

    // --- 服务端响应

    /**
     * 接收到RTC邀请
     */
    RTC_CALL(1),

    /**
     * 用户状态更新事件(用户加入频道)
     */
    CLIENT_JOIN(2),

    /**
     * 用户状态更新事件(用户退出频道)
     */
    CLIENT_LEAVE(3),

    /**
     * 用户状态更新事件(用户拒接邀请,不同意进入频道)
     */
    CLIENT_REJECT(4),

    /**
     * SDP数据转发
     */
    SDP_FORWARD(5),

    /**
     * candidate候选者数据转发
     */
    CANDIDATE_FORWARD(6);


    private final int cmdCode;

    WsRtcResponseSubCmdEnum(int cmdCode) {
        this.cmdCode = cmdCode;
    }

    public int getCmdCode() {
        return cmdCode;
    }
}
