package com.wecloud.im.thousandchat.param;

import com.wecloud.im.core.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author lixiaozhong
 * 最后一条已接收消息
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "LastestReceivedMsg")
public class LastestReceivedMsg implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "消息id，只需要发送最新的一条已接收消息", required = true)
    @NotNull(message = "消息ID不能为空")
    private Long lastestMsgId;

    @ApiModelProperty(value = "是否同时修改为已读状态", required = false)
    private Boolean readStatus = false;
}
