package com.wecloud.im.thousandchat.param;

import com.wecloud.im.core.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author lixiaozhong
 * 最新一条只读消息
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ConversationLastestReadMsg")
public class ConversationLastestReadMsg extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "最新的一条已读消息")
    private Long lastestReadMsgId;

    @ApiModelProperty(value = "最新的一条已接收消息")
    private Long lastestReceiveMsgId;

    @ApiModelProperty(value = "会话id")
    private Long conversationId;
}
