package com.wecloud.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.wecloud.im.entity.ImIosApns;
import com.wecloud.im.mapper.ImIosApnsMapper;
import com.wecloud.im.param.ImIosApnsQueryVo;
import com.wecloud.im.service.ImIosApnsService;
import com.wecloud.im.core.common.service.impl.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * apns配置表 服务实现类
 *
 * @author wei
 * @since 2021-09-18
 */
@Slf4j
@Service
@CacheConfig(cacheNames = "apns")
public class ImIosApnsServiceImpl extends BaseServiceImpl<ImIosApnsMapper, ImIosApns> implements ImIosApnsService {

    @Autowired
    private ImIosApnsMapper imIosApnsMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveImIosApns(ImIosApns imIosApns) throws Exception {
        return super.save(imIosApns);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateImIosApns(ImIosApns imIosApns) throws Exception {
        return super.updateById(imIosApns);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteImIosApns(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public ImIosApnsQueryVo getImIosApnsById(Long id) throws Exception {
        return imIosApnsMapper.getImIosApnsById(id);
    }

    @Override
//    @Cacheable(key = "#p0")
    public ImIosApns getImIosApnsByAppId(Long appId) {
        return this.getOne(new QueryWrapper<ImIosApns>().lambda().eq(
                ImIosApns::getFkAppId, appId
        ));
    }

//    @Override
//    public Paging<ImIosApnsQueryVo> getImIosApnsPageList(ImIosApnsPageParam imIosApnsPageParam) throws Exception {
//        Page<ImIosApnsQueryVo> page;
//        IPage<ImIosApnsQueryVo> iPage = imIosApnsMapper.getImIosApnsPageList(page, imIosApnsPageParam);
//        return new Paging<ImIosApnsQueryVo>(iPage);
//    }

}
