package com.wecloud.im.service;

import com.wecloud.im.core.common.api.ApiResult;

import com.alibaba.nacos.api.exception.NacosException;
import com.wecloud.im.param.ImTokenVerify;
import com.wecloud.im.vo.TokenVo;

/**
 * 终端表 服务类
 *
 * @author wei
 * @since 2021-04-27
 */
public interface ImClientLoginService {

    /**
     * 根据客户方生成签名字符串 验证通过则下发token
     *
     * @param imTokenVerify
     * @return
     */
    ApiResult<TokenVo> verifySign(ImTokenVerify imTokenVerify) throws NacosException;

    /**
     * 获取client Token
     * @Author luozh
     * @Date 2022年04月18日 10:56:24
     * @param
     * @Return
     */
    ApiResult<TokenVo> getToken(String clientId, Integer deviceType) throws NacosException;

}
