package com.wecloud.im.sdk.enums;

import com.wecloud.im.core.common.enums.BaseEnum;

/**
 * @Author wenzhida
 * @Date 2022/2/17 11:52
 * @Description 禁言选型枚举枚举
 */
public enum MutedEnum implements BaseEnum {

    /**
     * 1-未禁言
     */
    NO(1, "未禁言"),

    /**
     * 2 - 禁言
     */
    YES(2, "禁言");

    MutedEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final Integer code;
    private final String desc;


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
