package com.wecloud.im.param.add;

import com.wecloud.im.core.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 修改是否单向隐藏会话
 *
 * @author wei
 * @since 2021-05-07
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "修改是否单向隐藏会话")
public class ImConversationDisplayUpdate extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "会话id", required = true)
    private List<Long> conversationIds;

    @ApiModelProperty(value = "显示状态 1显示 0不显示", required = true)
    private Integer displayStatus;
}
