package com.wecloud.im.param;

import com.wecloud.im.core.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;

/**
 * @Author wenzhida
 * @Date 2022/2/15 20:45
 * @Description 获取某条消息已读人员入参
 */
@Getter
@Setter
@ApiModel(value = "获取某条消息已读人员入参")
public class GetReadersParam extends BaseEntity {

    private static final long serialVersionUID = -2415497107453497807L;

    @NotNull(message = "会话id不能为空")
    @ApiModelProperty("会话id")
    private Long conversationId;

    @NotNull(message = "消息id不能为空")
    @ApiModelProperty("消息id")
    private Long msgId;

}
