package com.wecloud.im.executor;

import cn.hutool.core.thread.ThreadFactoryBuilder;
import com.wecloud.im.server.model.WsConstants;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * ws消息下发 线程池
 */
public class SendMsgThreadPool {

    private static final ThreadFactory SEND_MSG_THREAD_FACTORY = new ThreadFactoryBuilder()
            .setNamePrefix("-sendM-").build();

    /**
     * 业务处理线程池
     */
    public static final ExecutorService SEND_MSG_THREAD_POOL_EXECUTOR =
            new ThreadPoolExecutor(WsConstants.CPU_PROCESSORS, WsConstants.CPU_PROCESSORS * 3,
                    1000L, TimeUnit.MILLISECONDS,
                    new LinkedBlockingQueue<Runnable>(102400), SEND_MSG_THREAD_FACTORY, new ThreadPoolExecutor.CallerRunsPolicy());

}
