package com.wecloud.im.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.wecloud.im.core.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 消息收件箱表
 *
 * @author wei
 * @since 2021-05-06
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@TableName("im_inbox")
@ApiModel(value = "ImInbox对象")
public class ImInbox extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "收件id不能为空")
    @ApiModelProperty("收件id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("读取时间")
    private Date readTime;

    @ApiModelProperty("接收时间")
    private Date receiverTime;

    @NotNull(message = "应用appid不能为空")
    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @NotNull(message = "接收客户端id不能为空")
    @ApiModelProperty("接收客户端id")
    private Long receiver;

    @NotNull(message = "消息id不能为空")
    @ApiModelProperty("消息id")
    private Long fkMsgId;

    @ApiModelProperty("0未读; 1已读")
    private Integer readMsgStatus;

    @ApiModelProperty("0未接收; 1已接收")
    private Integer receiverMsgStatus;

    @NotNull(message = "会话id不能为空")
    @ApiModelProperty("会话id")
    private Long fkConversationId;

}
