package com.wecloud.im.controller;

import com.wecloud.im.core.common.api.ApiResult;
import com.wecloud.im.core.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.nacos.api.exception.NacosException;
import com.wecloud.im.param.ClientLoginParam;
import com.wecloud.im.param.ImTokenVerify;
import com.wecloud.im.service.ImClientLoginService;
import com.wecloud.im.vo.TokenVo;

/**
 * token 控制器
 *
 * @author wei
 * @since 2021-04-27
 */
@Slf4j
@RestController
@RequestMapping("/token")
@Api(value = "token API", tags = {"申请token相关"})
public class TokenController extends BaseController {

    @Autowired
    private ImClientLoginService imClientLoginService;

    /**
     * 根据客户方生成签名字符串 验证通过则下发token
     */
    @PostMapping("/verify")
    @ApiOperation(value = "根据sign申请token", notes = "校验客户方生成的签名字符串,验证通过则下发token")
    public ApiResult<TokenVo> verify(@RequestBody ImTokenVerify imTokenVerify) throws NacosException {
        return imClientLoginService.verifySign(imTokenVerify);
    }

    /**
     * 根据客户方生成签名字符串 验证通过则下发token
     */
    @PostMapping("/getToken")
    @ApiOperation(value = "下发客户端token", notes = "下发客户端token")
    public ApiResult<TokenVo> getToken(@RequestBody ClientLoginParam clientLoginParam) throws NacosException {
        String clientId = clientLoginParam.getClientId();
        Integer deviceType = clientLoginParam.getDeviceType();
        return imClientLoginService.getToken(clientId, deviceType);
    }

}

