//package com.wecloud.im.controller;
//
//import com.wecloud.im.entity.ImApplication;
//import com.wecloud.im.param.ImApplicationPageParam;
//import com.wecloud.im.param.ImApplicationQueryVo;
//import com.wecloud.im.param.add.ImApplicationAdd;
//import com.wecloud.im.service.ImApplicationService;
//import com.wecloud.im.server.utils.RSAGenerator;
//import com.wecloud.im.core.common.api.ApiResult;
//import com.wecloud.im.core.common.controller.BaseController;
//import com.wecloud.im.core.core.pagination.Paging;
//import com.wecloud.im.core.core.validator.groups.Add;
//import com.wecloud.im.core.core.validator.groups.Update;
//import com.wecloud.im.core.log.annotation.OperationLog;
//import com.wecloud.im.core.log.enums.OperationLogType;
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiOperation;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.BeanUtils;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.validation.annotation.Validated;
//import org.springframework.web.bind.annotation.GetMapping;
//import org.springframework.web.bind.annotation.PostMapping;
//import org.springframework.web.bind.annotation.RequestBody;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RequestParam;
//import org.springframework.web.bind.annotation.RestController;
//
///**
// * 第三方应用表 控制器
// *
// * @author wei
// * @since 2021-04-27
// */
//@Slf4j
//@RestController
//@RequestMapping("/imApplication")
//@Api(value = "第三方应用表API", tags = {"第三方应用表"})
//public class ImApplicationController extends BaseController {
//
//    public static final String ADMIN_PWD = "si0132g9ad4gd6xv8x888wd6g86aga731h6pzc1pzc68b7eln96s2360j0sjkh028sj131h0gjb";
//
//    @Autowired
//    private ImApplicationService imApplicationService;
//
//    /**
//     * 添加第三方应用表
//     */
//    @PostMapping("/add")
//    @OperationLog(name = "添加第三方应用表", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加第三方应用表")
//    public ApiResult<Boolean> addImApplication(@Validated(Add.class) @RequestBody ImApplicationAdd imApplicationAdd) throws Exception {
//
//        if (!imApplicationAdd.getAdminPwd().equals(ADMIN_PWD)) {
//            return ApiResult.fail();
//        }
//
//        ImApplication imApplication = new ImApplication();
//        BeanUtils.copyProperties(imApplicationAdd, imApplication);
//
//        // 生成AppKey
//        String appKey = RSAGenerator.getAppKey();  //定义变量接收
//        // 生成appSecret
//        String appSecret = RSAGenerator.getAppSecret(appKey);
//
//        imApplication.setAppKey(appKey);
//        imApplication.setAppSecret(appSecret);
//
//        boolean flag = imApplicationService.saveImApplication(imApplication);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 修改第三方应用表
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改第三方应用表", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改第三方应用表")
//    public ApiResult<Boolean> updateImApplication(@Validated(Update.class) @RequestBody ImApplicationAdd imApplicationAdd) throws Exception {
//
//        if (!imApplicationAdd.getAdminPwd().equals(ADMIN_PWD)) {
//            return ApiResult.fail();
//        }
//
//        ImApplication imApplication = new ImApplication();
//        boolean flag = imApplicationService.updateImApplication(imApplication);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除第三方应用表
//     */
//    @PostMapping("/delete")
//    @OperationLog(name = "删除第三方应用表", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除第三方应用表")
//    public ApiResult<Boolean> deleteImApplication(@RequestParam("id") Long id, @RequestParam("pwd") String pwd) throws Exception {
//
//        if (!pwd.equals(ADMIN_PWD)) {
//            return ApiResult.fail();
//        }
//        boolean flag = imApplicationService.deleteImApplication(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取第三方应用表详情
//     */
//    @GetMapping("/info/")
//    @OperationLog(name = "第三方应用表详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "第三方应用表详情")
//    public ApiResult<ImApplicationQueryVo> getImApplication(@RequestParam("id") Long id, @RequestParam("pwd") String pwd) throws Exception {
//
//        if (!pwd.equals(ADMIN_PWD)) {
//            return null;
//        }
//
//        ImApplicationQueryVo imApplicationQueryVo = imApplicationService.getImApplicationById(id);
//        return ApiResult.ok(imApplicationQueryVo);
//    }
//
//    /**
//     * 第三方应用表分页列表
//     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "第三方应用表分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "第三方应用表分页列表")
//    public ApiResult<Paging<ImApplicationQueryVo>> getImApplicationPageList(@Validated @RequestBody ImApplicationPageParam imApplicationPageParam) throws Exception {
//
//        if (!imApplicationPageParam.getPwd().equals(ADMIN_PWD)) {
//            return null;
//        }
//        Paging<ImApplicationQueryVo> paging = imApplicationService.getImApplicationPageList(imApplicationPageParam);
//        return ApiResult.ok(paging);
//    }
//
//}
//
