package com.wecloud.im.action;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;

import com.wecloud.netty.dispatch.annotation.ActionMapping;
import com.wecloud.im.param.ChatSettingParam;
import com.wecloud.im.param.ImConvMemeClientRemarkNameParam;
import com.wecloud.im.param.ListConversationMembersParam;
import com.wecloud.im.param.add.ImConversationMemAttrUpdate;
import com.wecloud.im.service.ImConversationMembersService;
import com.wecloud.im.vo.ConversationMemberVo;
import com.wecloud.im.server.model.WsResponse;

/**
 * @Author luozh
 * @Date 2022年04月02日 16:41
 * @Version 1.0
 */
@Slf4j
@Component
@ActionMapping(value = "/im/conversationMembers")
@Api(value = "ws-会话成员API", tags = {"ws-会话成员"})
public class ConversationMembersAction {
    @Autowired
    private ImConversationMembersService imConversationMembersService;

    /**
     * 添加或修改会话成员备注
     * @return
     */
    @ActionMapping("/updateClientRemarkName")
    @ApiOperation(value = "添加或修改会话成员备注", notes = "权限:目前只有client成员自己有权限操作")
    public WsResponse<Map<String, Boolean>> saveOrUpdateClientRemarkName(ImConvMemeClientRemarkNameParam data) throws Exception {
        imConversationMembersService.saveOrUpdateClientRemarkName(data);
        return WsResponse.ok();
    }


    /**
     * 添加或修改会话成员拓展字段
     */
    @ActionMapping("/updateAttr")
    @ApiOperation(value = "添加或修改会话成员拓展字段", notes = "权限:目前只有client成员自己有权限操作")
    public WsResponse<Map<String, Boolean>> saveOrUpdateAttr(ImConversationMemAttrUpdate data) throws Exception {
        boolean r = imConversationMembersService.saveOrUpdateAttr(data);
        if (r) {
            return WsResponse.ok();
        } else {
            return WsResponse.fail();
        }
    }


    /**
     * 会话中成员表列表
     * @return
     */
    @ActionMapping("/getList")
    @ApiOperation(value = "获取会话中成员表列表")
    public WsResponse<Map<String, List<ConversationMemberVo>>> getImConversationMembersList(@Validated ListConversationMembersParam data) throws Exception {
        List<ConversationMemberVo> conversationMemberVoList = imConversationMembersService.getImConversationMembersList(data);
        Map<String, List<ConversationMemberVo>> result = new HashMap<>();
        result.put("result", conversationMemberVoList);
        return WsResponse.ok(result);
    }

    /**
     * 聊天设置
     * @Author luozh
     * @Date 2022年04月26日 11:48:59
     * @param
     * @Return
     */
    @ApiOperation(value = "聊天设置")
    @ActionMapping("/chatSetting")
    public WsResponse<Map<String, Boolean>> chatSetting(@RequestBody ChatSettingParam param) {
        imConversationMembersService.chatSetting(param);
        return WsResponse.ok();
    }
}
