package com.wecloud;

import com.wecloud.im.netty.core.NettyStart;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * netty随springboot项目启动而启动
 */
@Component
@Order(value = 1)//这里表示启动顺序
public class StartNettyService implements CommandLineRunner {
    @Value("${netty.port}")
    private int port;

    @Resource
    private NettyStart nettyServer;

    @Override
    @Async//注意这里，组件启动时会执行run，这个注解是让线程异步执行，这样不影响主线程
    public void run(String... args) throws Exception {
        nettyServer.run(port);
    }
}
