package com.wecloud.im.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <pre>
 * 会话表 查询结果对象
 * </pre>
 *
 * @author wei
 * @date 2021-05-07
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "ImConversationQueryVo对象")
public class ImConversationQueryVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会话id")
    private Long id;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("对话中最后一条消息的发送或接收时间")
    private Date lastMessage;

    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @ApiModelProperty("创建者客户端id")
    private Long creator;

    @ApiModelProperty("可选	 对话的名字，可为群组命名。")
    private String name;

    @ApiModelProperty("可选	自定义属性，供开发者扩展使用。")
    private String attributes;

    @ApiModelProperty("可选	对话类型标志，是否是系统对话，后面会说明。")
    private Boolean systemFlag;

    @ApiModelProperty("群成员数量")
    private Integer memberCount;

    @ApiModelProperty("是否万人群")
    private Boolean isThousand;
}
