package com.wecloud.im.service;

import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

import java.util.List;

import com.wecloud.dispatch.extend.ActionRequest;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.param.ClientInfoParam;
import com.wecloud.im.param.GetClientInfoParam;
import com.wecloud.im.param.ImClientPageParam;
import com.wecloud.im.param.ImClientQueryVo;
import com.wecloud.im.param.ImClientSimpleDto;
import com.wecloud.im.param.LogoutParam;
import com.wecloud.im.param.add.ClientDeviceUpdateParam;
import com.wecloud.im.param.add.ImClientHeadPortraitAdd;
import com.wecloud.im.param.add.ImClientHeadPortraitAndNicknameUpdate;
import com.wecloud.im.param.add.ImClientNicknameAdd;
import com.wecloud.im.param.add.ImClientNicknameUpdate;
import com.wecloud.im.vo.ClientInfoVo;
import com.wecloud.im.vo.GetInfoListVo;
import com.wecloud.im.vo.MyInfoVo;

/**
 * 终端表 服务类
 *
 * @author wei
 * @since 2021-04-27
 */
public interface ImClientService extends BaseService<ImClient> {

    /**
     * 查询我的信息
     * @return
     */
    MyInfoVo getMyInfo(ActionRequest request);

    /**
     * 更新头像
     * @param imClientHeadPortraitAdd
     * @return
     */
    boolean updateHeadPortrait(ActionRequest request, ImClientHeadPortraitAdd imClientHeadPortraitAdd);

    /**
     * 修改昵称
     * @param imClientNicknameUpdate
     * @return
     */
    boolean updateNickname(ActionRequest request, ImClientNicknameUpdate imClientNicknameUpdate);

    boolean updateHeadAndNickname(ActionRequest request, ImClientHeadPortraitAndNicknameUpdate imClientHeadPortraitAndNicknameUpdate);


    /**
     * 根据ids获取Client的头像昵称
     *
     * @param getClientInfoParam
     * @return
     * @throws Exception
     */
    List<GetInfoListVo> getInfoList(ActionRequest request, GetClientInfoParam getClientInfoParam) throws Exception;

    /**
     * 获取群里成员信息
     * @param param
     * @return
     */
    ClientInfoVo getClientInfo(ActionRequest request, ClientInfoParam param);


    boolean updateNickname(ActionRequest request, ImClientNicknameAdd imClientNicknameAdd) throws Exception;

    /**
     * 保存
     *
     * @param imClient
     * @return
     * @throws Exception
     */
    boolean saveImClient(ImClient imClient) throws Exception;

    /**
     * 添加或修改推送设备信息
     *
     * @param imClientDevice
     * @return
     */
    boolean updateDeviceInfo(ClientDeviceUpdateParam imClientDevice);

    /**
     * 登出操作
     * @param param
     * @return
     */
    boolean logout(ActionRequest request, LogoutParam param);


    /**
     * 修改
     *
     * @param imClient
     * @return
     * @throws Exception
     */
    boolean updateImClient( ImClient imClient) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteImClient( Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param imClientPageParam
     * @return
     * @throws Exception
     */
    Paging<ImClientQueryVo> getImClientPageList(ActionRequest request, ImClientPageParam imClientPageParam) throws Exception;


    /**
     * 获取当前请求的client对象
     *
     * @return
     */
    ImClient getCurrentClient();

    ImClient getCacheImClient(Long applicationId, String clientId);

    void deleteCacheImClient(Long applicationId, String clientId);

    /**
     * 根据ID获取client对象，有缓存
     *
     * @param id
     * @return
     * @throws Exception
     */
    ImClient getCacheImClient(Long id);

    /**
     * 获取client的简单对象，减少开销
     * @param applicationId
     * @param clientIds
     * @return
     */
    List<ImClientSimpleDto> getSimpleClients(Long applicationId, List<String> clientIds);

    List<ImClientSimpleDto> getSimpleClients(List<Long> ids);
}
