package com.wecloud.im.service;

import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

import com.wecloud.dispatch.extend.ActionRequest;
import com.wecloud.im.entity.ImClientBlacklist;
import com.wecloud.im.param.ImClientBlacklistPageParam;
import com.wecloud.im.param.ImClientBlacklistQueryVo;
import com.wecloud.im.param.add.ImClientBlacklistUpdate;

/**
 * 黑名单 服务类
 *
 * @author wei
 * @since 2021-06-17
 */
public interface ImClientBlacklistService extends BaseService<ImClientBlacklist> {


    /**
     * 当前客户端是否被拉黑
     *
     * @param currentClientId 当前客户端
     * @param toClientId      对方客户端
     * @return
     */
    boolean isBeBlack(String currentClientId, String toClientId);

    /**
     * 拉入黑名单
     *
     * @param imClientBlacklistUpdate
     * @return
     * @throws Exception
     */
    Boolean addImClientBlacklist(ActionRequest request, ImClientBlacklistUpdate imClientBlacklistUpdate);

    /**
     * 移出黑名单
     *
     * @param imClientBlacklistUpdate
     * @return
     * @throws Exception
     */
    Boolean removeImClientBlacklist(ActionRequest request, ImClientBlacklistUpdate imClientBlacklistUpdate);

    /**
     * 获取分页对象
     *
     * @return
     * @throws Exception
     */
    Paging<ImClientBlacklistQueryVo> getImClientBlacklistPageList(ActionRequest request, ImClientBlacklistPageParam imClientBlacklistPageParam);

}
