package com.wecloud.im.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;

/**
 * @Description 服务器下发事件的枚举
 * @Author lixiaozhong
 * @Date 2022/1/14 12:02 下午
 */
public enum EventResponseSubCmdEnum implements BaseEnum {

    FRIEND_APPLY(1, "好友申请"),
    FRIEND_APPROVE(2, "好友认证：同意/拒绝");

    private final Integer code;
    private final String desc;

    EventResponseSubCmdEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
