package com.wecloud.im.ws.model;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Description null
 * @Author hewei hwei1233@163.com
 * @Date 2019-12-05
 */
@Data
@Accessors(chain = true)
public class ResponseModel<T> implements Serializable {

    /**
     * 下发在线消息
     */
    public static final Integer ONLINE_MSG = 2;

    /**
     * 响应数据
     */
    public static final Integer RES = 1;

    /**
     * 枚举类UriPathEnum 请求uri的编码
     * 由于websocket使用同一个通道发送数据，需要区分不同类型请求
     */
    private Integer cmd;

    /**
     * 状态码
     */
    private int code;

    /**
     * 状态描述
     */
    private String msg;

    /**
     * json数据
     */
    private T data;

    /**
     * 请求id, 以判空是否发送成功, 服务端处理完成后返回
     * 可以以当前时间戳为id
     */
    private String reqId;

}
