package com.jumeirah.common.service;

import com.jumeirah.common.entity.BusinessPlain;
import com.jumeirah.common.param.BusinessPlainPageParam;
import com.jumeirah.common.vo.BusinessPlainQueryForAppVo;
import com.jumeirah.common.vo.BusinessPlainQueryVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 公务机出售/托管表 服务类
 *
 * @author giao
 * @since 2020-10-14
 */
public interface BusinessPlainService extends BaseService<BusinessPlain> {

    /**
     * 保存
     *
     * @param businessPlain
     * @return
     * @throws Exception
     */
    boolean saveBusinessPlain(BusinessPlain businessPlain) throws Exception;

    /**
     * 修改
     *
     * @param businessPlain
     * @return
     * @throws Exception
     */
    boolean updateBusinessPlain(BusinessPlain businessPlain) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteBusinessPlain(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    BusinessPlainQueryVo getBusinessPlainById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param businessPlainPageParam
     * @return
     * @throws Exception
     */
    Paging<BusinessPlainQueryVo> getBusinessPlainPageList(BusinessPlainPageParam businessPlainPageParam) throws Exception;

    Paging<BusinessPlainQueryForAppVo> getBusinessPlainPageListForApp(BusinessPlainPageParam businessPlainPageParam) throws Exception;


}
