package com.jumeirah.api.app.controller;

import com.jumeirah.common.entity.Merchant;
import com.jumeirah.common.service.MerchantService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author: JJww
 * @Date:2020/11/5
 */
@Slf4j
@RestController
@RequestMapping("/app/merchant")
@Api(value = "商户相关接口")
public class MerchantController {

    @Autowired
    private MerchantService merchantService;


    /**
     * 航空公司商家表
     */
    @GetMapping("/list")
    @OperationLog(name = "航空公司商家列表", type = OperationLogType.LIST)
    @ApiOperation(value = "航空公司商家列表")
    public ApiResult<List<Merchant>> getMerchantList() {
        return ApiResult.ok(merchantService.getMerchantList());
    }

}
