package com.wecloud.im.externalaccess.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @Author wenzhida
 * @Date 2022/2/21 16:58
 * @Description 用户信息
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "用户信息")
@TableName("im_user")
public class User extends BaseEntity {

    private static final long serialVersionUID = -8075685205533406087L;

    @NotNull(message = "主键id不能为空")
    @ApiModelProperty("主键id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("蓝豆号")
    private String idNumber;

    @ApiModelProperty("手机号码")
    private String phone;

    @ApiModelProperty("身份证号码")
    private String idCardNo;

    @ApiModelProperty("邮箱号码")
    private String email;

    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("性别")
    private Integer sex;

    @ApiModelProperty("头像")
    private String headPortrait;

    @ApiModelProperty("昵称")
    private String nickname;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

}
