package com.wecloud.im.param;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 终端表
 *
 * @author wei
 * @since 2021-04-27
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImClientSimpleDto简单对象")
public class ImClientSimpleDto extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("客户端id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @ApiModelProperty("客户方提供的唯一id")
    private String clientId;
}
