package com.wecloud.im.friend.service;

import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.enums.EventResponseSubCmdEnum;
import com.wecloud.im.friend.param.FriendApplyEventDto;
import com.wecloud.im.friend.param.FriendApproveEventDto;
import com.wecloud.im.friend.param.ImFriendApplyDto;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.im.ws.enums.WsResponseCmdEnum;
import com.wecloud.im.ws.enums.WsRtcResponseSubCmdEnum;
import com.wecloud.im.ws.model.WsResponse;
import com.wecloud.im.ws.model.WsResponseEventData;
import com.wecloud.im.ws.model.request.PushVO;
import com.wecloud.im.ws.sender.AsyncPush;
import com.wecloud.im.ws.sender.ChannelSender;
import com.wecloud.rtc.entity.response.RtcResponseBase;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Description TODO
 * @Author lixiaozhong
 * @Date 2022/1/13 5:35 下午
 */
@Component
public class FriendEventSender {

    @Autowired
    private ChannelSender channelSender;

    @Autowired
    private AsyncPush systemPush;

    @Autowired
    private ImApplicationService imApplicationService;

    private final static String FRIEND_APPLY_TITLE = "好友申请";
    private final static String FRIEND_APPLY_TITLE_SUB = "您有好友申请待验证";
    private final static String FRIEND_APPROVE_TITLE = "好友验证结果";
    private final static String FRIEND_APPROVE_TITLE_AGREE = "您的好友拒绝了您的好友申请";
    private final static String FRIEND_APPROVE_TITLE_REJECT = "您的好友同意了您的好友申请";


    public void sendFriendApplyEventMsg(ImClient receiveClient, String requestRemark) {

        FriendApplyEventDto applyDto = new FriendApplyEventDto();
        applyDto.setSubCmd(EventResponseSubCmdEnum.FRIEND_APPLY.getCode());
        applyDto.setRequestRemark(requestRemark);
        applyDto.setFriendClientId(receiveClient.getClientId());

        //  向接收方推送
        WsResponse<FriendApplyEventDto> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.CONVERSATION_EVENT_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(applyDto);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, receiveClient.getId());

        ImApplication app = imApplicationService.getById(receiveClient.getFkAppid());

        PushVO pushVO = new PushVO();
        pushVO.setTitle(FRIEND_APPLY_TITLE);
        pushVO.setSubTitle(FRIEND_APPLY_TITLE_SUB);
        systemPush.push(pushVO, receiveClient, app);
    }

    public void sendFriendApproveEventMsg(ImClient receiveClient, boolean isAgree, String rejectRemark) {

        FriendApproveEventDto approveDto = new FriendApproveEventDto();
        approveDto.setSubCmd(EventResponseSubCmdEnum.FRIEND_APPROVE.getCode());
        approveDto.setAgree(isAgree);
        approveDto.setRejectRemark(rejectRemark);
        approveDto.setFriendClientId(receiveClient.getClientId());

        //  向接收方推送
        WsResponse<FriendApproveEventDto> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.CONVERSATION_EVENT_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(approveDto);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, receiveClient.getId());

        ImApplication app = imApplicationService.getById(receiveClient.getFkAppid());

        PushVO pushVO = new PushVO();
        pushVO.setTitle(FRIEND_APPROVE_TITLE);
        pushVO.setSubTitle(isAgree? FRIEND_APPROVE_TITLE_AGREE : FRIEND_APPROVE_TITLE_REJECT);
        systemPush.push(pushVO, receiveClient, app);
    }
}
