package com.jumeirah.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jumeirah.common.entity.PlainType;
import com.jumeirah.common.enums.PlainTypeStatusEnum;
import com.jumeirah.common.mapper.PlainTypeMapper;
import com.jumeirah.common.service.PlainTypeService;
import com.jumeirah.common.param.PlainTypePageParam;
import com.jumeirah.common.vo.PlainTypeQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.transaction.annotation.Transactional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 飞机型号表 服务实现类
 *
 * @author wei
 * @since 2020-10-09
 */
@Slf4j
@Service
public class PlainTypeServiceImpl extends BaseServiceImpl<PlainTypeMapper, PlainType> implements PlainTypeService {

    @Autowired
    private PlainTypeMapper plainTypeMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean savePlainType(PlainType plainType) throws Exception {
        return super.save(plainType);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updatePlainType(PlainType plainType) throws Exception {
        return super.updateById(plainType);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deletePlainType(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public PlainTypeQueryVo getPlainTypeById(Long id) throws Exception {
        return plainTypeMapper.getPlainTypeById(id);
    }

    @Override
    public Paging<PlainTypeQueryVo> getPlainTypePageList(PlainTypePageParam plainTypePageParam) throws Exception {
        Page<PlainTypeQueryVo> page = new PageInfo<>(plainTypePageParam, OrderItem.desc(getLambdaColumn(PlainType::getCreateTime)));
        IPage<PlainTypeQueryVo> iPage = plainTypeMapper.getPlainTypePageList(page, plainTypePageParam);
        return new Paging<PlainTypeQueryVo>(iPage);
    }

    @Override
    public List<PlainType> getAllMap() {
        return this.list(new QueryWrapper<PlainType>().lambda()
                .eq(PlainType::getStatus, PlainTypeStatusEnum.OK.getCode())
                .orderByAsc(PlainType::getSeriesType, PlainType::getCreateTime)
        );
    }

}
