package com.wecloud.im.sdk.common.auth;

import lombok.Getter;

/**
 * 证书
 * @Author luozh
 * @Date 2022年04月14日 11:17
 * @Version 1.0
 */
@Getter
public class Credentials {

    private String appKey;

    private String appSecret;

    public Credentials(String appKey, String appSecret) {
        if (appKey == null || "".equals(appKey)) {
            throw new InvalidCredentialsException("App key id should not be null or empty.");
        }
        if (appSecret == null || "".equals(appSecret)) {
            throw new InvalidCredentialsException("Secret access key should not be null or empty.");
        }
        this.appKey = appKey;
        this.appSecret = appSecret;
    }
}
