package com.wecloud.im.tillo.app_ws.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class FileHelperOfflineModel implements Serializable {

    private String messageId;
    @ApiModelProperty(value = "消息内容")
    private String content;
    @ApiModelProperty(value = "消息类型 text, audio,  image, file, video, location")
    private String type;
    @ApiModelProperty(value = "资源id")
    private String sourceId;
    @ApiModelProperty(value = "时长（s）")
    private Integer duration;
    @ApiModelProperty(value = "位置信息")
    private String locationInfo;
    @ApiModelProperty(value = "图片/视频尺寸相关信息")
    private String measureInfo;
    @ApiModelProperty(value = "消息回执id")
    private String backId;
    @ApiModelProperty(value = "文件名")
    private String fileName;
    @ApiModelProperty(value = "文件大小")
    private String fileSize;
    @ApiModelProperty(value = "消息渠道 singleChat, groupChat,systemNotice,syncMySend")
    private String route;
    @ApiModelProperty(value = "时间戳")
    private Date timestamp;


}
