package com.wecloud.multimeet.service;

import com.wecloud.multimeet.entity.response.MultiMeetAgreeResponse;
import com.wecloud.multimeet.entity.response.MultiMeetInviteResponse;
import com.wecloud.multimeet.entity.response.MultiMeetLeaveResponse;
import com.wecloud.multimeet.entity.response.MultiMeetRejectResponse;

/**
 * @Author wenzhida
 * @Date 2022/3/7 21:47
 * @Description 多人音视频 webSocket下发指令数据
 */
public interface WsMultiMeetWrite {

    /**
     * 发送邀请
     * @param multiMeetInviteResponse
     * @param toFkClientId
     */
    void invite(MultiMeetInviteResponse multiMeetInviteResponse, Long toFkClientId);

    /**
     * 拒接邀请
     * @param multiMeetRejectResponse
     * @param toFkClientId
     */
    void reject(MultiMeetRejectResponse multiMeetRejectResponse, Long toFkClientId);

    /**
     * 同意进入会议
     * @param multiMeetAgreeResponse
     * @param toFkClientId
     */
    void agree(MultiMeetAgreeResponse multiMeetAgreeResponse, Long toFkClientId);

    /**
     * 主动离开会议
     * @param multiMeetLeaveResponse
     * @param toFkClientId
     */
    void leave(MultiMeetLeaveResponse multiMeetLeaveResponse, Long toFkClientId);

}
