package com.wecloud.dispatch.general.config;

import com.wecloud.dispatch.general.impl.GeneralActionBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @author lixiaozhong
 */
@Configuration
@EnableConfigurationProperties(GeneralActionDispatcherProperties.class)
public class DispatcherConfig {

	@Autowired
	private GeneralActionDispatcherProperties generalActionDispatcherProperties;

	@Bean
	public GeneralActionDispatcher generalActionDispatcher(GeneralActionBox generalActionBox) {

		Set<String> actionPackages = generalActionDispatcherProperties.getScanPackage();

		GeneralActionDispatcher bean = new GeneralActionDispatcher();

		bean.add(generalActionBox);

		if (null != actionPackages && !actionPackages.isEmpty()) {
			for (String path : actionPackages) {
				bean.scan(path);
			}
		} else {
			bean.scan("com.wecloud");
		}
		return bean;
	}

	@Bean
	public GeneralActionBox generalActionBox() {
		GeneralActionBox bean = new GeneralActionBox();
		return bean;
	}

}
