package com.wecloud.im.user.controller;

import com.alibaba.fastjson.JSON;
import com.wecloud.im.user.param.ChangePhoneParam;
import com.wecloud.im.user.param.CheckPhoneParam;
import com.wecloud.im.user.param.FindUserParam;
import com.wecloud.im.user.param.GetUserParam;
import com.wecloud.im.user.param.LoginSuccessDto;
import com.wecloud.im.user.param.ModifyHeadPortraitParam;
import com.wecloud.im.user.param.ModifyLandouParam;
import com.wecloud.im.user.param.ModifyNicknameParam;
import com.wecloud.im.user.param.ModifySexParam;
import com.wecloud.im.user.param.RegisterSuccessDto;
import com.wecloud.im.user.param.ResetPasswordParam;
import com.wecloud.im.user.param.UserBaseDto;
import com.wecloud.im.user.param.UserLoginParam;
import com.wecloud.im.user.param.UserRegisterParam;
import com.wecloud.im.user.service.UserService;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author wenzhida
 * @Date 2022/2/21 17:05
 * @Description 用户控制器
 */
@Slf4j
@RestController
@RequestMapping("/user")
@Api(value = "用户相关API", tags = {"用户"})
public class UserController extends BaseController {

    @Autowired
    private UserService userService;

    @PostMapping("/checkPhone")
    @ApiOperation(value = "校验手机号码是否未注册用户 true-可使用 false-不可使用")
    public ApiResult<Boolean> checkPhone(@RequestBody @Validated CheckPhoneParam param) {
        log.info("校验手机号码是否未注册用户 {}", JSON.toJSONString(param));
        if (param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        return ApiResult.ok(userService.checkPhone(param));
    }

    @PostMapping("/register")
    @ApiOperation(value = "用户注册接口")
    public ApiResult<RegisterSuccessDto> register(@RequestBody @Validated UserRegisterParam param) {
        log.info("用户注册接口入参 {}", JSON.toJSONString(param));
        if (param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        String userId = userService.registerUser(param);
        return ApiResult.ok(new RegisterSuccessDto(userId));
    }

    @PostMapping("/login")
    @ApiOperation(value = "用户登录接口")
    public ApiResult<LoginSuccessDto> login(@RequestBody @Validated UserLoginParam param) {
        log.info("用户登录接口入参 {}", JSON.toJSONString(param));
        if (param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        LoginSuccessDto loginUser = userService.loginUser(param);
        return ApiResult.ok(loginUser);
    }

    @PostMapping("/resetPassword")
    @ApiOperation(value = "重置密码接口")
    public ApiResult<Boolean> resetPassword(@RequestBody @Validated ResetPasswordParam param) {
        log.info("重置密码接口入参 {}", JSON.toJSONString(param));
        if (param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        userService.resetPassword(param);
        return ApiResult.ok();
    }

    @PostMapping("/changePhone")
    @ApiOperation(value = "更换手机号接口")
    public ApiResult<Boolean> changePhone(@RequestBody @Validated ChangePhoneParam param) {
        log.info("更换手机号接口入参 {}", JSON.toJSONString(param));
        if (param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        userService.changePhone(param);
        return ApiResult.ok();
    }

    @PostMapping("/myInfo")
    @ApiOperation(value = "查找我的信息")
    public ApiResult<UserBaseDto> myInfo() {
        UserBaseDto user = userService.myInfo();
        return ApiResult.ok(user);
    }

    @PostMapping("/findUser")
    @ApiOperation(value = "查找用户")
    public ApiResult<UserBaseDto> findUser(@RequestBody @Validated FindUserParam param) {
        log.info("查找用户入参 {}", JSON.toJSONString(param));
        if (param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        UserBaseDto user = userService.findUser(param);
        return ApiResult.ok(user);
    }

    @PostMapping("/getUserByUserId")
    @ApiOperation(value = "根据用户id查找用户信息")
    public ApiResult<UserBaseDto> getUserByUserId(@RequestBody @Validated GetUserParam param) {
        log.info("根据用户id查找用户信息入参 {}", JSON.toJSONString(param));
        if (param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        UserBaseDto user = userService.getUserByUserId(param);
        return ApiResult.ok(user);
    }

    @PostMapping("/modifyHeadPortrait")
    @ApiOperation(value = "修改头像")
    public ApiResult<Boolean> modifyHeadPortrait(@RequestBody @Validated ModifyHeadPortraitParam param) {
        log.info("修改头像入参 {}", JSON.toJSONString(param));
        if (param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        userService.modifyHeadPortrait(param);
        return ApiResult.ok();
    }

    @PostMapping("/modifyNickname")
    @ApiOperation(value = "修改昵称")
    public ApiResult<Boolean> modifyNickname(@RequestBody @Validated ModifyNicknameParam param) {
        log.info("修改昵称入参 {}", JSON.toJSONString(param));
        if (param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        userService.modifyNickname(param);
        return ApiResult.ok();
    }

    @PostMapping("/modifyLandouNo")
    @ApiOperation(value = "修改蓝豆号")
    public ApiResult<Boolean> modifyLandouNo(@RequestBody @Validated ModifyLandouParam param) {
        log.info("修改蓝豆号入参 {}", JSON.toJSONString(param));
        if (param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        userService.modifyLandouNo(param);
        return ApiResult.ok();
    }

    @PostMapping("/modifySex")
    @ApiOperation(value = "修改性别")
    public ApiResult<Boolean> modifySex(@RequestBody @Validated ModifySexParam param) {
        log.info("修改性别入参 {}", JSON.toJSONString(param));
        if (param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        userService.modifySex(param);
        return ApiResult.ok();
    }



}

