package com.wecloud.im.controller;

import io.geekidea.springbootplus.framework.common.api.ApiResult;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.List;

import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.wecloud.im.param.group.CreateGroupParam;
import com.wecloud.im.param.group.DismissGroupParam;
import com.wecloud.im.param.group.JoinGroupParam;
import com.wecloud.im.param.group.LeaveGroupParam;
import com.wecloud.im.param.group.ListGroupMembersParam;
import com.wecloud.im.param.group.MutedMembersParam;
import com.wecloud.im.service.ImGroupService;

/**
 * 群聊接口
 * @Author luozh
 * @Date 2022年05月10日 14:14
 * @Version 1.0
 */
@AllArgsConstructor
@Slf4j
@RestController
@RequestMapping("/group")
public class ImGroupController {

    private final ImGroupService groupService;

    /**
     * 创建群组
     * @Author luozh
     * @Date 2022年05月10日 02:16:19
     * @Return
     */
    @PostMapping("/createGroup")
    public ApiResult<Long> createGroup(@RequestBody CreateGroupParam param) {
        log.info("创建群组请求 参数: {}", JSON.toJSONString(param));
        List<String> memberClientIds = Arrays.asList(param.getMemberIds().split(","));
        Long conversationId = groupService.createGroup(param.getUserId(), param.getGroupName(), memberClientIds);
        return ApiResult.ok(conversationId);
    }

    /**
     * 解散群组
     * @Author luozh
     * @Date 2022年05月10日 02:16:19
     * @Return
     */
    @PostMapping("/dismissGroup")
    public ApiResult<Boolean> dismissGroup(@RequestBody DismissGroupParam param) {
        log.info("解散群组请求 参数: {}", JSON.toJSONString(param));
        return ApiResult.ok(groupService.dismissGroup(param.getUserId(), param.getGroupId()));
    }

    /**
     * 加入群组
     * @Author luozh
     * @Date 2022年05月10日 02:16:19
     * @Return
     */
    @PostMapping("/joinGroup")
    public ApiResult<Integer> joinGroup(@Validated @RequestBody JoinGroupParam param) {
        log.info("加入群组请求 参数: {}", JSON.toJSONString(param));
        List<String> memberIds = Arrays.asList(param.getUserIds().split(","));
        return ApiResult.ok(groupService.joinGroup(param.getInviterUserId(), param.getGroupId(), memberIds));
    }

    /**
     * 离开群组
     * @Author luozh
     * @Date 2022年05月10日 02:16:19
     * @Return
     */
    @PostMapping("/leaveGroup")
    public ApiResult<Integer> leaveGroup(@RequestBody LeaveGroupParam param) {
        log.info("离开群组请求 参数: {}", JSON.toJSONString(param));
        List<String> memberIds = Arrays.asList(param.getUserIds().split(","));
        return ApiResult.ok(groupService.leaveGroup(param.getGroupId(), memberIds));
    }

    /**
     *
     * @Author luozh
     * @Date 2022年05月10日 02:16:19
     * @Return
     * @return
     */
    @PostMapping("/listGroupMembers")
    public ApiResult<List<String>> listGroupMembers(@RequestBody ListGroupMembersParam param) {
        log.info("获取群组成员请求 参数: {}", JSON.toJSONString(param));
        return ApiResult.ok(groupService.listGroupMembers(param.getGroupId()));
    }

    /**
     * 禁言群成员
     * @Author luozh
     * @Date 2022年05月10日 02:16:19
     * @Return
     * @return
     */
    @PostMapping("/mutedMembers")
    public ApiResult<Boolean> mutedMembers(@RequestBody MutedMembersParam param) {
        log.info("禁言群成员请求 参数: {}", JSON.toJSONString(param));
        return ApiResult.ok(groupService.mutedMembers(param));
    }
}
